# choices-separator [![NPM version](https://img.shields.io/npm/v/choices-separator.svg?style=flat)](https://www.npmjs.com/package/choices-separator) [![NPM monthly downloads](https://img.shields.io/npm/dm/choices-separator.svg?style=flat)](https://npmjs.org/package/choices-separator) [![NPM total downloads](https://img.shields.io/npm/dt/choices-separator.svg?style=flat)](https://npmjs.org/package/choices-separator) [![Linux Build Status](https://img.shields.io/travis/enquirer/choices-separator.svg?style=flat&label=Travis)](https://travis-ci.org/enquirer/choices-separator)

> Separator for choices arrays in prompts. Based on the Separator from inquirer.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save choices-separator
```

## Usage

```js
var Separator = require('choices-separator');
var Prompt = require('prompt-checkbox');

var prompt = new Prompt({
  message: 'Which do you prefer?',
  name: 'favorites',
  choices: [
    new Separator(' = Color = '),
    {name: 'red'},
    {name: 'yellow', checked: true },
    {name: 'blue'},
    new Separator(' = Shape = '),
    {name: 'circle'},
    {name: 'triangle'},
    {name: 'square'}
  ]
});

prompt.run()
  .then(function(answer) {
    console.log(answer)
  });
```

## API

### [Separator](index.js#L21)

Separator object, used in choices arrays in prompts, to create a visual break between sections. The default separator line is `────────` styled with [ansi-dim](https://github.com/jonschlinkert/ansi-dim).

**Params**

* `options` **{String}**: Optionally provide a custom `line` and or `prefix` to use.

**Example**

```js
new Separator('----');
new Separator({line: '----'})
new Separator({line: '----', prefix: '    '});
```

### [.raw](index.js#L56)

Returns the `separator.line` stripped of ansi styling.

* `returns` **{String}**

**Example**

```js
var separator = new Separator();
console.log(separator.raw());
//=> '────────'
```

### [.render](index.js#L72)

Render `separator.prefix` plus `separator.line`.

* `returns` **{String}**

**Example**

```js
var separator = new Separator();
console.log(separator.render());
//=> ' \u001b[2m────────\u001b[22m\n')
```

### [.exclude](index.js#L83)

Returns false if the given object is a separator.

**Params**

* `choice` **{Object}**: object to test against
* `returns` **{Boolean}**: Returns false if the given object is a separator

### [.toString](index.js#L93)

Stringify separator

* `returns` **{String}**: Returns the `separator.line` string

## Attribution

Originally inspired by the `Separator` class from Inquirer.

## About

### Related projects

[enquirer](https://www.npmjs.com/package/enquirer): Intuitive, plugin-based prompt system for node.js. Much faster and lighter alternative to Inquirer, with all… [more](https://github.com/enquirer/enquirer) | [homepage](https://github.com/enquirer/enquirer "Intuitive, plugin-based prompt system for node.js. Much faster and lighter alternative to Inquirer, with all the same prompt types and more, but without the bloat.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 17, 2017._